/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.file;

import com.quantumdata.fmteditor.InstrumentListener;
import com.quantumdata.fmteditor.InstrumentSource;
import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.fmteditor.file.FmtFileType;
import com.quantumdata.fmteditor.fmtwidgets.ConnectPanel;
import com.quantumdata.fmteditor.fmtwidgets.PathSelectPanel;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDList;
import com.quantumdata.widgets.QDListItem;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDProgressBar;
import com.quantumdata.widgets.QDStdUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CmdDataSelector
extends QDPanel {
    private static final int EDGE_SPACE = 10;
    private boolean m_openNotSave;
    private JTextField m_name;
    private QDList m_fileList;
    private DefaultListModel m_listModel;
    private QDButton m_okBtn;
    private Icon m_fileIcon;
    private InstrumentSource m_isrc;
    private ConnectPanel m_conPanel;
    private CardLayout m_cards;
    private PathSelectPanel m_paths;
    private QDPanel m_centerPanel;
    private QDPanel m_filePanel;
    private QDPanel m_btnPanel;
    private QDLabel m_message;
    private QDPanel m_progPanel;
    private JProgressBar m_progBar;
    private Loader m_loader;
    private ActionListener m_listener = null;
    private boolean m_ignoreSelChange = false;

    public CmdDataSelector(FmtFileType fmtFileType, boolean bl, InstrumentSource instrumentSource) {
        this.m_isrc = instrumentSource;
        if (fmtFileType.getCmdType().length() == 0) {
            fmtFileType = FmtFileType.FORMAT;
        }
        this.m_openNotSave = bl;
        this.initComponents(fmtFileType);
    }

    public void activated() {
        this.connectionChanged();
        this.checkPath();
        this.nameChanged('\uffff');
    }

    public void setActionListener(ActionListener actionListener) {
        this.m_listener = actionListener;
    }

    public String getFileName() {
        return this.m_paths.getFullFileName(this.m_name.getText());
    }

    public boolean fileExists() {
        String string = this.m_name.getText();
        if (string.length() == 0) {
            return false;
        }
        try {
            String string2 = this.m_isrc.getInstrument().tryQuery(this.m_paths.getType().getCmdType() + "L? \"" + string + "\"");
            if (Integer.parseInt(string2) == 1) {
                return true;
            }
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        return false;
    }

    public void setFileName(String string) {
        this.m_name.setText(string);
        this.checkPath();
        this.nameChanged('\uffff');
    }

    public FmtFileType getSelectedType() {
        return this.m_paths.getType();
    }

    private void checkPath() {
        String string = this.m_name.getText();
        string.replace('\\', '/');
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(n + 1);
        String string3 = string.substring(0, n);
        String string4 = this.m_paths.getSelectedPath();
        if (string4 != null && string4.equalsIgnoreCase(string3)) {
            this.m_name.setText(string2);
        }
    }

    private void initComponents(FmtFileType fmtFileType) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.m_cards = new CardLayout();
        this.m_centerPanel = new QDPanel((LayoutManager)this.m_cards);
        this.createButtonPanel();
        this.createProgPanel();
        this.createFilePanel();
        this.add((Component)this.m_centerPanel, "Center");
        this.add((Component)this.createTopPanel(fmtFileType), "North");
        this.add((Component)this.createBottomPanel(), "South");
    }

    private QDPanel createTopPanel(FmtFileType fmtFileType) {
        QDPanel qDPanel = new QDPanel((LayoutManager)new BorderLayout());
        this.m_conPanel = new ConnectPanel(this.m_isrc.getInstrumentOwner());
        qDPanel.add((Component)((Object)this.m_conPanel), (Object)"North");
        this.m_conPanel.setListener(new InstrumentListener(){

            public void connected(RemoteInstrument remoteInstrument) {
                CmdDataSelector.this.connectionChanged();
            }

            public void disconnected(RemoteInstrument remoteInstrument) {
                CmdDataSelector.this.connectionChanged();
            }
        });
        this.m_conPanel.useCompactForm(true);
        this.m_paths = new PathSelectPanel(fmtFileType, this.m_isrc);
        this.m_paths.setItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CmdDataSelector.this.pathSelected();
                }
            }
        });
        qDPanel.add((Component)((Object)this.m_paths), (Object)"South");
        this.m_paths.enableTypeSelection(this.m_openNotSave);
        return qDPanel;
    }

    private QDPanel createBottomPanel() {
        QDPanel qDPanel = new QDPanel((LayoutManager)new BorderLayout());
        QDPanel qDPanel2 = new QDPanel((LayoutManager)new BorderLayout());
        qDPanel2.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        QDLabel qDLabel = new QDLabel("File Name: ");
        qDLabel.setForeground(QDStdUI.getActionForeground());
        this.m_name = new JTextField(20);
        this.m_name.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                CmdDataSelector.this.nameChanged(keyEvent.getKeyChar());
            }
        });
        qDPanel2.add((Component)qDLabel, (Object)"West");
        qDPanel2.add((Component)this.m_name, (Object)"Center");
        qDPanel.add((Component)qDPanel2, (Object)"North");
        QDPanel qDPanel3 = new QDPanel((LayoutManager)new BorderLayout());
        qDPanel2 = new QDPanel();
        qDPanel2.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.m_okBtn = new QDButton(this.m_openNotSave ? "  Open  " : "  Save  ");
        this.m_okBtn.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.m_okBtn.addActionListener((ActionListener)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CmdDataSelector.this.approved();
            }
        });
        this.m_okBtn.setEnabled(false);
        qDPanel2.add((Component)this.m_okBtn);
        QDButton qDButton = new QDButton("  Cancel  ");
        qDButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        qDButton.addActionListener((ActionListener)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CmdDataSelector.this.canceled();
            }
        });
        qDPanel2.add((Component)qDButton);
        qDPanel3.add((Component)qDPanel2, (Object)"East");
        qDPanel.add((Component)qDPanel3, (Object)"South");
        return qDPanel;
    }

    private void createFilePanel() {
        this.m_listModel = new DefaultListModel();
        this.m_fileList = new QDList((ListModel)this.m_listModel);
        this.m_fileList.setSelectionMode(0);
        this.m_fileList.setLayoutOrientation(2);
        this.m_fileList.setVisibleRowCount(0);
        this.m_fileList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CmdDataSelector.this.fileSelectionChanged();
            }
        });
        this.m_fileList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    CmdDataSelector.this.fileSelectionChanged();
                    if (CmdDataSelector.this.m_okBtn.isEnabled()) {
                        CmdDataSelector.this.approved();
                    }
                }
            }
        });
        this.m_fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.m_filePanel = new QDPanel((LayoutManager)new BorderLayout());
        this.m_filePanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        JScrollPane jScrollPane = new JScrollPane((Component)this.m_fileList);
        this.m_filePanel.add((Component)jScrollPane, (Object)"Center");
        this.m_centerPanel.add((Component)this.m_filePanel, (Object)"File");
    }

    private void createButtonPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_btnPanel = new QDPanel((LayoutManager)gridBagLayout);
        this.m_message = new QDLabel("  ");
        this.m_message.setHorizontalAlignment(0);
        this.m_message.setForeground(Color.red);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_message, gridBagConstraints);
        this.m_btnPanel.add((Component)this.m_message);
        this.m_centerPanel.add((Component)this.m_btnPanel, (Object)"Btn");
    }

    private void createProgPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_progPanel = new QDPanel((LayoutManager)gridBagLayout);
        this.m_progBar = new QDProgressBar();
        this.m_progBar.setIndeterminate(false);
        this.m_progBar.setStringPainted(true);
        this.m_progBar.setString("Please Wait...");
        this.m_progBar.setBorderPainted(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.m_progBar, gridBagConstraints);
        this.m_progPanel.add((Component)this.m_progBar);
        this.m_centerPanel.add((Component)this.m_progPanel, (Object)"Prog");
    }

    private void showProgress(String string) {
        this.m_progBar.setIndeterminate(true);
        this.m_progBar.setString("     " + string + "     ");
        this.m_cards.show((Container)this.m_centerPanel, "Prog");
    }

    private void showFileList() {
        this.m_progBar.setIndeterminate(false);
        this.m_cards.show((Container)this.m_centerPanel, "File");
    }

    private void showButtonPanel(String string) {
        this.m_progBar.setIndeterminate(false);
        this.m_message.setText(string);
        this.m_cards.show((Container)this.m_centerPanel, "Btn");
    }

    private void approved() {
        if (this.m_listener != null) {
            this.m_listener.actionPerformed(new ActionEvent((Object)this, 1, "APPROVED"));
        }
    }

    private void canceled() {
        if (this.m_listener != null) {
            this.m_listener.actionPerformed(new ActionEvent((Object)this, 0, "CANCELED"));
        }
    }

    private boolean readPath() {
        boolean bl;
        if (!this.m_isrc.isConnected()) {
            return false;
        }
        boolean bl2 = this.setInstrEnabled(false);
        try {
            bl = this.m_paths.readPath();
        }
        catch (InstrumentException instrumentException) {
            MsgLog.error(instrumentException.getMessage());
            this.m_conPanel.setInstrument(null);
            return false;
        }
        if (!bl) {
            this.showButtonPanel("Unable to read the current path");
            this.setInstrEnabled(false);
            return false;
        }
        this.setInstrEnabled(bl2);
        return true;
    }

    private void pathSelected() {
        try {
            this.m_paths.writePath();
        }
        catch (InstrumentException instrumentException) {
            MsgLog.error(instrumentException.getMessage());
            this.m_conPanel.setInstrument(null);
            return;
        }
        this.readPath();
        this.updateFileList();
    }

    private void connectionChanged() {
        boolean bl = this.m_isrc.isConnected();
        this.setInstrEnabled(bl);
        if (!bl) {
            this.showButtonPanel(" ");
            return;
        }
        if (this.readPath()) {
            this.updateFileList();
        }
    }

    private boolean setInstrEnabled(boolean bl) {
        boolean bl2 = this.m_name.isEnabled();
        this.m_fileList.setEnabled(bl);
        this.m_paths.setEnabled(bl);
        this.m_name.setEnabled(bl);
        return bl2;
    }

    private void updateFileList() {
        if (this.m_loader != null) {
            return;
        }
        this.setInstrEnabled(false);
        this.showProgress("Reading, please wait...");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CmdDataSelector.this.loadFileList();
                    }
                });
            }
        };
        Timer timer = new Timer(500, actionListener);
        timer.setRepeats(false);
        timer.start();
    }

    private void loadFileList() {
        if (!this.isVisible()) {
            return;
        }
        if (this.m_loader != null) {
            return;
        }
        this.m_listModel.clear();
        if (!this.m_isrc.isConnected()) {
            this.showButtonPanel("Not Connected");
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_loader = new Loader();
        this.m_loader.start();
    }

    private void loadCompleted() {
        String[] stringArray;
        if (!this.m_loader.success) {
            MsgLog.error(this.m_loader.response);
            this.showButtonPanel(this.m_loader.response);
            if (this.m_isrc.isConnected()) {
                this.m_paths.setEnabled(true);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.m_loader = null;
            return;
        }
        this.showFileList();
        for (String string : stringArray = this.m_loader.response.split("\r\n")) {
            if ((string = string.trim()).length() <= 0) continue;
            this.m_listModel.addElement(new QDListItem(string, this.m_fileIcon));
        }
        this.setInstrEnabled(true);
        this.checkPath();
        this.nameChanged('\uffff');
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.m_loader = null;
    }

    private void fileSelectionChanged() {
        if (this.m_ignoreSelChange) {
            return;
        }
        QDListItem qDListItem = (QDListItem)this.m_fileList.getSelectedValue();
        if (qDListItem != null) {
            this.setFileName(qDListItem.getText());
        }
    }

    private void nameChanged(char c) {
        String string = this.m_name.getText();
        if (c != '\uffff') {
            string = string + c;
        }
        this.m_okBtn.setEnabled((string = string.toLowerCase()).length() > 0);
        if (string.length() == 0) {
            this.selectFile(-1);
            return;
        }
        int n = this.m_fileList.getData().getSize();
        for (int i = 0; i < n; ++i) {
            QDListItem qDListItem = (QDListItem)this.m_fileList.getData().get(i);
            if (!qDListItem.getText().toLowerCase().startsWith(string)) continue;
            this.selectFile(i);
            return;
        }
        this.selectFile(-1);
    }

    private void selectFile(int n) {
        this.m_ignoreSelChange = true;
        this.m_fileList.setSelectedIndex(n);
        if (n >= 0) {
            this.m_fileList.ensureIndexIsVisible(n);
        }
        this.m_ignoreSelChange = false;
    }

    private class Loader
    extends Thread {
        public String response = "";
        public boolean success = false;

        private Loader() {
        }

        public void run() {
            try {
                RemoteInstrument remoteInstrument = CmdDataSelector.this.m_isrc.getInstrument();
                String string = CmdDataSelector.this.m_paths.getType().getCmdType() + "Q? 1 999";
                this.response = remoteInstrument.tryQuery(string, 120000);
                this.success = true;
            }
            catch (InstrumentException instrumentException) {
                this.response = instrumentException.getMessage();
                this.success = false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CmdDataSelector.this.loadCompleted();
                }
            });
        }
    }
}

